# vol5-kernel-to-metric-cc (Sim-2b)

Compact-curvature (CC) translator pass of the geometry simulation.

## Inputs

Place FPHS snapshot files as `.npz` with key `E0` (shape L×L) under:

```
data/inputs/
  <gauge>/L<L>/b<b>/k<kappa>/f<f>/seed<seed>/E0.npz
```

## Run

```bash
pip install -r env/requirements.txt
export PYTHONPATH=$PWD/src
python -m vol5_k2m_cc.run_geometry_cc --config configs/geometry_cc.yaml --data-dir data/inputs --out runs_cc
python scripts/aggregate_cc.py --runs-dir runs_cc --out results_cc/summary.csv
python scripts/accept_cc.py --summary results_cc/summary.csv
```

Windows PowerShell:

```powershell
$env:PYTHONPATH = "$PWD/src"
python -m vol5_k2m_cc.run_geometry_cc --config configs\geometry_cc.yaml --data-dir data\inputs --out runs_cc
python scripts\aggregate_cc.py --runs-dir runs_cc --out results_cc\summary.csv
python scripts\accept_cc.py --summary results_cc\summary.csv
```

## Gates

- s_phi ∈ [-1.15, -0.85]
- s_grad ∈ [-2.2, -1.8]
- lensing R² ≥ 0.90 for at least one λ
- S⁺ non-empty (typical coverage 0.5–5%)
